/*****************************************************************************
 * Copyright (c) 2007, Freescale Semiconductor                               *
 * Freescale Application Note                                                *
 *                                                                           *
 * File name   : main.c                                                      *
 * Project name: USB demo software using CMX USB stack                       *
 *                                                                           *
 * Author      : Paolo Alcantara                                             *
 * Department  : RTAC Americas                                               *
 *                                                                           *
 * Description :                                                             *
 *                                                                           *
 * History     :                                                             *
 * 08/27/2007  : First version of the software                               *
 * 01/04/2007  : Second version                                              *
 * 08/18/2009  : Third version: V1 support: preliminar test                  *
 *                                                                           *
 *****************************************************************************/

#include "target.h"
#include "drivers/usb/usb_driver.h"

/*
 * MAIN FUNCTION:
 */

hcc_reg8 bulk_transfer;
extern hcc_u16 variable_length;

void main()
{
#if 0
  for(;;)
  ;/*infinite loop*/

#else
  hcc_u8 ep1[8];		//ep1 (interrupt)
  hcc_u8 ep2[32];		//ep2 (bulk)

  /* controllers' descriptors */  
  ep_state_t endpoints[2];

  /*V1 stuff*/
  stack_init(0x88);
    
  /****************** init chip *********************/
  hw_init();

  /*HW stuff*/
  Usb_Vbus_Off();

  /* ep IN: counter */
  endpoints[0].ep_state = EP_NOT_READY;
  endpoints[0].ep_buffer = ep1;
  endpoints[0].ep_length = 8;
  /*test*/
  ep1[0] = 0xAA;

  /* ep OUT: counter */
  endpoints[1].ep_state = EP_NOT_READY;
  endpoints[1].ep_buffer = ep2;
  endpoints[1].ep_length = 32; 

  /* flag to start bulk out transfer */
  bulk_transfer = 0;

  /***************** USB init ****************************/
  /* USB irq is level = 6, priority = 6. */
  usb_init(/*(6<<3) | 6, 0*/); 

#if 0
  for(;;)
  ;/*infinite loop*/
#else
  for(;;)
  {	  	
  	/* IN interrupt transaction */
  	USBsend(1,&endpoints[0]);
  	
  	/***************** OUT bulk: starts by a setup packet*/
  	if(bulk_transfer)
  	{
  		endpoints[1].ep_length = variable_length;
  		
  		if(USBinput_ready(2, &endpoints[1]))
  		{
  			bulk_transfer = 0;
  		}
  	}
		
  }
#endif
  
#endif  
}
/****************************** END OF FILE **********************************/
